package org.jboss.soa.eclipse.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.io.FileUtils;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/**
 * This object is a helper class which helps create the java project by
 * copying in the template files, and create the classpath using the 
 */
public class ESBProjectCreator {
	private static final String BUNDLE_NAME = "org.jboss.soa.esb.eclipse.template";
	private static final String TEMPLATE_FILES_DIR = "template";
	
	/**
	 * Copy all of the template files from the plugin into the new eclipse 
	 * project.
	 */
	public void FindZipFile(IProject f_project) {
		URL url = null;
		try {
			url = FileLocator.toFileURL(Platform.getBundle(BUNDLE_NAME).getEntry(TEMPLATE_FILES_DIR));
			File esbFilesDir = new File(url.getFile());
			String esbFiles[] = esbFilesDir.list();
			for (int i = 0; i < esbFiles.length; i++) {
				File temp = new File(esbFilesDir + File.separator + esbFiles[i]);
				if (temp.isDirectory()) {
					FileUtils.copyDirectoryToDirectory(temp, new File(f_project.getLocationURI()));
				} else {
					FileUtils.copyFileToDirectory(temp,  new File(f_project.getLocationURI()));
				}
			}
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
	
	/**
	 * 
	 * @param f_page the WizardNewProjectCreationPage
	 * @param f_project the IProject being created
	 * @param f_workbench workbench
	 * @param monitor monitor
	 * @throws JavaModelException java model exception
	 * @throws CoreException core exception
	 */
	public void createJavaProject(WizardNewProjectCreationPage f_page,
			IProject f_project, IWorkbench f_workbench, IProgressMonitor monitor)
			throws JavaModelException, CoreException { 			
			monitor.beginTask("Creating ESB Package", 0);
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
			IProject project = root.getProject(f_page.getProjectName());
				
			IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
				
			if(!Platform.getLocation().equals(f_page.getLocationPath()))
				description.setLocation(f_page.getLocationPath());
				
			description.setNatureIds(new String[] { JavaCore.NATURE_ID });
			ICommand buildCommand = description.newCommand();
			buildCommand.setBuilderName(JavaCore.BUILDER_ID);
			description.setBuildSpec(new ICommand[] { buildCommand });
			project.create(description, monitor);
			project.open(monitor);

			IJavaProject javaProject = JavaCore.create(project);
				
			IFolder srcFolder = project.getFolder("src");
			srcFolder.create(true, true, monitor);

			IFolder binFolder = project.getFolder("bin");
			binFolder.create(true, true, monitor);
				
			IFolder libFolder = project.getFolder("lib");
			libFolder.create(true, true, monitor);
			IFolder libExtFolder = project.getFolder("lib/ext");	
			FindZipFile(project);
				
			javaProject.setOutputLocation(binFolder.getFullPath(), monitor);
			
			IClasspathEntry[] libraryClasspath = new IClasspathEntry[] {
					JavaCore.newLibraryEntry(libExtFolder.getFile("jbossall-client.jar").getFullPath(), null, null),
					JavaCore.newLibraryEntry(libFolder.getFile("jbossesb-listeners.jar").getFullPath(), null, null),
					JavaCore.newLibraryEntry(libFolder.getFile("jbossesb-rosetta.jar").getFullPath(), null, null),
					JavaCore.newLibraryEntry(libFolder.getFile("jbossesb-services.jar").getFullPath(), null, null)
			};
			IClasspathEntry[] classpath = new IClasspathEntry[2 + libraryClasspath.length];
			// Source entry must be first in classpath
			classpath[0] = JavaCore.newSourceEntry(project.getProject().getFullPath().append(new Path("/src")));
			// Add the JRE for the classpath
			classpath[1] = JavaRuntime.getDefaultJREContainerEntry();
			// Add all of the jars
			int counter = 2;			
			for (int i = 0; i < libraryClasspath.length; i++) {
				classpath[counter++] = libraryClasspath[i];
			}
			
			// Set the raw classpath
			javaProject.setRawClasspath(classpath, binFolder.getFullPath(), monitor);
				
			project.refreshLocal(IResource.DEPTH_INFINITE, null);
			monitor.worked(1);
	}
}
