/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.test.ws.jaxws.samples.swaref;

import org.jboss.wsf.spi.annotation.WebContext;

import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.jws.WebMethod;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.ws.WebServiceException;
import javax.activation.DataHandler;
import java.rmi.RemoteException;
import java.io.IOException;

@Stateless
@WebService(name="RpcLitEndpoint", serviceName="RpcLitEndpointService")
@SOAPBinding(style = SOAPBinding.Style.RPC)
@WebContext(contextRoot = "jaxws-swaref")
public class RpcLitEndpointImpl implements RpcLitEndpoint
{
   @WebMethod
   @XmlAttachmentRef
   public DataHandler parameterAnnotation(@XmlAttachmentRef DataHandler data)  throws RemoteException
   {
      try
      {
         System.out.println("Got " + data.getContent() );
         return new DataHandler("Server data", "text/plain");
      }
      catch (IOException e)
      {
         throw new WebServiceException(e); 
      }

   }

   @WebMethod
   public DocumentPayload beanAnnotation(DocumentPayload payload) throws RemoteException
   {
      try
      {
         System.out.println("Got " + payload.getData().getContent() );
         DataHandler data = new DataHandler("Server data", "text/plain");
         return new DocumentPayload(data);
      }
      catch (IOException e)
      {
         throw new WebServiceException(e);
      }
   }
}
