/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.msg;

import javax.naming.InitialContext;

import org.apache.cactus.ServletTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class TimerRepeatTest extends ServletTestCase {

  public void testTimerRepeat() throws Exception {
    Recorder.resetCollections();
    deployProcess();
    System.out.println("=== START ===============================================================================");
    long tokenId = launchProcess();
    assertEquals(0, Recorder.executions);
    Thread.sleep(500);
    assertEquals(0, Recorder.executions);
    Thread.sleep(1000);
    assertEquals(1, Recorder.executions);
    Thread.sleep(1000);
    assertEquals(1, Recorder.executions);
    Thread.sleep(1000);
    assertEquals(2, Recorder.executions);
    System.out.println("=== END ===============================================================================");
    deleteTimer(tokenId);
  }

  public static class CancelTimerCommand implements Command {
    private static final long serialVersionUID = 1L;
    long tokenId;
    public CancelTimerCommand(long tokenId) {
      this.tokenId = tokenId;
    }
    public Object execute(JbpmContext jbpmContext) throws Exception {
      Token token = jbpmContext.loadToken(tokenId);
      jbpmContext.getJobSession().cancelTimersByName("hello", token);
      return null;
    }
  }
  
  public void deleteTimer(long tokenId) {
    log.debug("deleting the timer");
    execute(new CancelTimerCommand(tokenId));
  }

  public static Object execute(Command command) {
    Object returnValue;
    try {
      InitialContext initialContext = new InitialContext();
      LocalCommandServiceHome localCommandServiceHome = (LocalCommandServiceHome) initialContext.lookup("CommandServiceBean");
      LocalCommandService localCommandService = localCommandServiceHome.create();
      returnValue = localCommandService.execute(command);
      localCommandService.remove();
    } catch (Exception e) {
      e.printStackTrace();
      throw new RuntimeException("couldn't execute command", e);
    }
    return returnValue;
  }
  

  public void deployProcess() {
    log.debug("start deploy process");
    execute(new Command() {
      private static final long serialVersionUID = 1L;
      public Object execute(JbpmContext jbpmContext) throws Exception {
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlString(
          "<process-definition name='repeat included'>" +
          "  <start-state>" +
          "    <transition to='a' />" +
          "  </start-state>" +
          "  <task-node name='a'>" +
          "    <task name='hello'>" +
          "      <timer duedate='1 seconds' repeat='2 seconds'>" +
          "        <action name='hello' class='"+ActionRecorder.class.getName()+"' />" +
          "      </timer>" +
          "    </task>" +
          "  </task-node>" +
          "</process-definition>"
        );
        
        log.debug("deploying process");
        jbpmContext.deployProcessDefinition(processDefinition);

        return processDefinition;
      }
    });
  }
  
  public long launchProcess() {
    Object returnValue = execute(new Command() {
      private static final long serialVersionUID = 1L;
      public Object execute(JbpmContext jbpmContext) throws Exception {
        ProcessInstance processInstance = jbpmContext.newProcessInstanceForUpdate("repeat included");
        processInstance.signal();
        return new Long(processInstance.getRootToken().getId());
      }
    });
    return ((Long)returnValue).longValue();
  }

  private static Log log = LogFactory.getLog(TimerTest.class);

}
