package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NamedElement;

public class NamedElementConfigurationComposite implements SelectionListener {
	
	public static NamedElementConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		NamedElementConfigurationComposite result = new NamedElementConfigurationComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}
	
	private TabbedPropertySheetWidgetFactory widgetFactory;
	private Composite parent;
	
	private Label nameLabel;
	private Text nameText;
	
	private NamedElement namedElement;
	
	private NamedElementConfigurationComposite() {}
	
	public void setNamedElement(NamedElement namedElement) {
		if (this.namedElement == namedElement) return;
		unhookSelectionListener();
		this.namedElement = namedElement;
		if (namedElement == null) {
			clearControls();
		} else {
			updateControls();
			hookSelectionListener();
		}
	}
	
	private void hookSelectionListener() {
		nameText.addSelectionListener(this);
	}
	
	private void unhookSelectionListener() {
		nameText.removeSelectionListener(this);
	}
	
	private void clearControls() {
		nameText.setText("");
	}
	
	private void updateControls() {
		String name = namedElement.getName();
		if (name != null) {
			nameText.setText(name);
		} else {
			nameText.setText("");
		}
	}
	
	private void create() {
        nameLabel = widgetFactory.createLabel(parent, "Name"); 
        nameText = widgetFactory.createText(parent, "");
        nameLabel.setLayoutData(createNameLabelLayoutData());
        nameText.setLayoutData(createNameTextLayoutData());
	}
	
	private FormData createNameTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(nameLabel, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createNameLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	

	public void widgetDefaultSelected(SelectionEvent e) {
		if (e.widget == nameText) {
			namedElement.setName(nameText.getText());
		}
	}

	public void widgetSelected(SelectionEvent e) {
	}
	
}
