package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.jpdl.model.JpdlElement;
import org.jbpm.gd.jpdl.ui.JpdlLabelProvider;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;

public class JpdElementlLabelProvider implements ILabelProvider {
	
	private JpdlElement getJpdlElement(Object element) {
		JpdlElement result = null;
		if (element instanceof IStructuredSelection) {
			element = ((IStructuredSelection)element).getFirstElement();
		}
        if (element instanceof NotationElementGraphicalEditPart) {
        	result = (JpdlElement)((NotationElementGraphicalEditPart)element).getNotationElement().getSemanticElement();
        } else if (element instanceof JpdlOutlineEditPart) {
        	result = (JpdlElement)((JpdlOutlineEditPart)element).getModel();
        }
        return result;
	}
		
	public Image getImage(Object element) {
		Image result = null;
		JpdlElement jpdlElement = getJpdlElement(element);
		if (jpdlElement != null) {
			result = JpdlLabelProvider.getImage(jpdlElement);
		}
		return result;
	}

	public String getText(Object element) {
		String result = element.toString();
		JpdlElement jpdlElement = getJpdlElement(element);
		if (jpdlElement != null) {
			result = JpdlLabelProvider.getLabel(jpdlElement);
		}
		return result;
	}

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

}
