package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.TaskContainer;

public class TaskListOutlineEditPart extends JpdlElementOutlineEditPart {
	
	public TaskListOutlineEditPart(TaskContainer model) {
		super(model);
	}

	protected String getIconName() {
		return "tasks_multiple.gif";
	}
	
	protected String getText() {
		return "Tasks";
	}
	
	protected List getModelChildren() {
		List result = new ArrayList();
		Task[] tasks = ((TaskContainer)getModel()).getTasks();
		for (int i = 0; i < tasks.length; i++) {
			result.add(tasks[i]);
		}
		return result;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("taskAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("taskRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
}
