package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class NodeElementListOutlineEditPart extends JpdlElementOutlineEditPart {
	
	public NodeElementListOutlineEditPart(NodeElementContainer model) {
		super(model);
	}

	protected String getIconName() {
		return "node_elements_multiple.gif";
	}
	
	protected String getText() {
		return "Nodes";
	}
	
	protected List getModelChildren() {
		List result = new ArrayList();
		NodeElement[] nodes = ((NodeElementContainer)getModel()).getNodeElements();
		for (int i = 0; i < nodes.length; i++) {
			result.add(nodes[i]);
		}
		return result;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("nodeElementAdd") || 
				eventName.equals("startStateAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("nodeElementRemove") || 
				eventName.equals("startStateRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
}
