package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.EventContainer;

public class EventListOutlineEditPart extends JpdlElementOutlineEditPart {
	
	public EventListOutlineEditPart(EventContainer model) {
		super(model);
	}

	protected String getIconName() {
		return "events_multiple.gif";
	}
	
	protected String getText() {
		return "Events";
	}
	
	protected List getModelChildren() {
		List result = new ArrayList();
		Event[] events = ((EventContainer)getModel()). getEvents();
		for (int i = 0; i < events.length; i++) {
			result.add(events[i]);
		}
		return result;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("eventAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("eventRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
}
