package org.jbpm.gd.jpdl.ui.notation;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;

public class JpdlRootContainer extends RootContainer {

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("startStateAdd") || eventName.equals("nodeElementAdd")) {
			AbstractJpdlElement jpdlElement = (AbstractJpdlElement)evt.getNewValue();
			AbstractNotationElement notationElement = getRegisteredNotationElementFor(jpdlElement);
			if (notationElement == null) {
				notationElement = getFactory().create(JpdlNotationMapping.getNotationElementId(jpdlElement.getElementId()));
				notationElement.setSemanticElement(jpdlElement);
				notationElement.register();
			}
			addNode((Node)notationElement);
			jpdlElement.addPropertyChangeListener(notationElement);
		}
		if (eventName.equals("startStateRemove") || eventName.equals("nodeElementRemove")) {
			AbstractJpdlElement jpdlElement = (AbstractJpdlElement)evt.getOldValue();
			AbstractNotationElement notationElement = getRegisteredNotationElementFor(jpdlElement);
			if (notationElement != null) {
				jpdlElement.removePropertyChangeListener(notationElement);
				removeNode((Node)notationElement);
				notationElement.unregister();
			}
		}
	}
	
}
