package org.jbpm.gd.jpdl.ui;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.jpdl.model.JpdlElement;

public class JpdlLabelProvider {

	private static Map iconNameMap;
	private static Map labelMap;
	
	private static Map getIconNameMap() {
		if (iconNameMap == null) {
			initializeIconNameMap();
		}
		return iconNameMap;
	}
	
	private static Map getLabelMap() {
		if (labelMap == null) {
			initializeLabelMap();
		}
		return labelMap;
	}
	
	private static void initializeIconNameMap() {
		iconNameMap = new HashMap();
		iconNameMap.put("org.jbpm.gd.jpdl.core.action", "action_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.assignment", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.cancelTimer", "cancel_timer_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.condition", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.controller", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.configInfoElement", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.createTimer", "create_timer_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.decision", "decision_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.endState", "end_state_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.event", "event_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.exceptionHandler", "exception_handler_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.fork", "fork_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.handler", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.join", "join_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.mail", "mail_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.mailNode", "mail_node_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.node", "node_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.processDefinition", "process_definition_enabled.gif" );
		iconNameMap.put("org.jbpm.gd.jpdl.core.processState", "process_state_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.script", "script_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.startState", "start_state_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.state", "state_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.subject", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.subprocess", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.superState", "super_state_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.swimlane", "swimlane_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.task", "task_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.taskNode", "task_node_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.text", null);
		iconNameMap.put("org.jbpm.gd.jpdl.core.timer", "timer_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.transition", "transition_enabled.gif");
		iconNameMap.put("org.jbpm.gd.jpdl.core.variable", null);
	}
	
	private static void initializeLabelMap() {
		labelMap = new HashMap();
		labelMap.put("org.jbpm.gd.jpdl.core.action", "Action");
		labelMap.put("org.jbpm.gd.jpdl.core.assignment", "Assignment");
		labelMap.put("org.jbpm.gd.jpdl.core.cancelTimer", "Cancel Timer");
		labelMap.put("org.jbpm.gd.jpdl.core.condition", "Condition");
		labelMap.put("org.jbpm.gd.jpdl.core.controller", "Controller");
		labelMap.put("org.jbpm.gd.jpdl.core.configInfoElement", "Configuration Information Element");
		labelMap.put("org.jbpm.gd.jpdl.core.createTimer", "Create Timer");
		labelMap.put("org.jbpm.gd.jpdl.core.decision", "Decision");
		labelMap.put("org.jbpm.gd.jpdl.core.endState", "End State");
		labelMap.put("org.jbpm.gd.jpdl.core.event", "Event");
		labelMap.put("org.jbpm.gd.jpdl.core.exceptionHandler", "Exception Handler");
		labelMap.put("org.jbpm.gd.jpdl.core.fork", "Fork");
		labelMap.put("org.jbpm.gd.jpdl.core.handler", "Handler");
		labelMap.put("org.jbpm.gd.jpdl.core.join", "Join");
		labelMap.put("org.jbpm.gd.jpdl.core.mail", "Mail");
		labelMap.put("org.jbpm.gd.jpdl.core.mailNode", "Mail Node");
		labelMap.put("org.jbpm.gd.jpdl.core.node", "Node");
		labelMap.put("org.jbpm.gd.jpdl.core.processDefinition", "Process Definition" );
		labelMap.put("org.jbpm.gd.jpdl.core.processState", "Process State");
		labelMap.put("org.jbpm.gd.jpdl.core.script", "Script");
		labelMap.put("org.jbpm.gd.jpdl.core.startState", "Start State");
		labelMap.put("org.jbpm.gd.jpdl.core.state", "State");
		labelMap.put("org.jbpm.gd.jpdl.core.subject", "Subject");
		labelMap.put("org.jbpm.gd.jpdl.core.subprocess", "Subprocess");
		labelMap.put("org.jbpm.gd.jpdl.core.superState", "Superstate");
		labelMap.put("org.jbpm.gd.jpdl.core.swimlane", "Swimlane");
		labelMap.put("org.jbpm.gd.jpdl.core.task", "Task");
		labelMap.put("org.jbpm.gd.jpdl.core.taskNode", "Task Node");
		labelMap.put("org.jbpm.gd.jpdl.core.text", "Text");
		labelMap.put("org.jbpm.gd.jpdl.core.timer", "Timer");
		labelMap.put("org.jbpm.gd.jpdl.core.transition", "Transition");
		labelMap.put("org.jbpm.gd.jpdl.core.variable", "Variable");
	}
	
	public static String getIconName(JpdlElement element) {
		return (String)getIconNameMap().get(element.getElementId());
	}
	
	public static ImageDescriptor getImageDescriptor(JpdlElement element) {
		ImageDescriptor result = null;
		String iconName = getIconName(element);
		if (iconName != null) {
			String descriptorString = "icons/full/obj16/" + iconName;
			result = ImageDescriptor.createFromURL(
					Platform.getBundle("org.jbpm.gd.jpdl.ui").getEntry(descriptorString));
		}
		return result;
	}
	
	public static Image getImage(ImageDescriptor descriptor) {
		return JpdlSharedImages.INSTANCE.getImage(descriptor);
	}
	
	public static Image getImage(JpdlElement element) {
		ImageDescriptor imageDescriptor = getImageDescriptor(element);
		if (imageDescriptor == null) {
			return null;
		}
		return getImage(imageDescriptor);
	}
	
	public static String getLabel(JpdlElement element) {
		return (String)getLabelMap().get(element.getElementId());
	}
		
}
