/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.tools;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.1 $ $Date: 2007/06/05 20:50:18 $
 */
public class ModuleDeployerTest extends TestCase {

  private ModuleDeployHelper deployHelper = new ModuleDeployHelper();
  private URL moduleLocator;

  private static final String modulePath = ModuleDeployerTest.class.getResource("hello.war")
      .getPath();

  protected void setUp() throws Exception {
    moduleLocator = new URL("http://localhost:8080/hello/greeter");

    // deploy module
    deployHelper.deploy(modulePath);
  }

  public void testDeploy() throws Exception {
    // verify web service is available
    HttpURLConnection httpConnection = (HttpURLConnection) moduleLocator.openConnection();
    try {
      // web services bound to SOAP over HTTP require the POST method
      // however, getting a 405 confirms the service is active
      assertEquals(HttpURLConnection.HTTP_BAD_METHOD, httpConnection.getResponseCode());
    }
    finally {
      httpConnection.disconnect();
    }

    // undeploy module
    deployHelper.undeploy(modulePath);
  }

  public void testUndeploy() throws Exception {
    // undeploy module
    deployHelper.undeploy(modulePath);

    // verify web application is unavailable
    HttpURLConnection httpConnection = (HttpURLConnection) moduleLocator.openConnection();
    try {
      assertEquals(HttpURLConnection.HTTP_NOT_FOUND, httpConnection.getResponseCode());
    }
    finally {
      httpConnection.disconnect();
    }
  }

  public static Test suite() {
    // deploy process
    File processFile = new File(ModuleDeployerTest.class.getResource("hello-process.zip").getPath());
    ProcessDeployer processDeployer = new ProcessDeployer();
    processDeployer.deployProcess(processFile);

    return new TestSuite(ModuleDeployerTest.class);
  }
}
