/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.tools.ant;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import org.jbpm.bpel.tools.ProcessDeployer;

/**
 * Submits process archives to the deployment servlet.
 * @author Alejandro Guizar
 * @version $Revision: 1.1 $ $Date: 2007/06/09 23:36:36 $
 */
public class DeployProcessTask extends Task {

  private File processfile;
  private String host;
  private Integer port;
  private String context;

  public void execute() throws BuildException {
    ProcessDeployer processDeployer = new ProcessDeployer();

    if (host != null)
      processDeployer.setHost(host);
    if (port != null)
      processDeployer.setPort(port.intValue());
    if (context != null)
      processDeployer.setContext(context);

    processDeployer.deployProcess(processfile);

    int problemCount = processDeployer.getProblemHandler().getProblemCount();
    if (problemCount > 0)
      throw new BuildException("Problems (" + problemCount + " item[s])");
  }

  public void setProcessfile(File processfile) {
    this.processfile = processfile;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public void setPort(Integer port) {
    this.port = port;
  }

  public void setContext(String context) {
    this.context = context;
  }
}