/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.struct;

import java.util.Collection;

import junit.framework.TestCase;

import org.jbpm.bpel.graph.basic.Empty;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.struct.While;
import org.jbpm.bpel.sublang.def.Expression;

/**
 * @author Juan Cantu
 * @version $Revision: 1.3 $ $Date: 2007/03/22 13:32:55 $
 */
public class WhileDefTest extends TestCase {

  While _while;
  Activity child;
  Activity otherChild;

  public void setUp() {
    _while = new While();
    child = new Empty("first");
    otherChild = new Empty("second");
  }

  public void testAddNode() {
    _while.addNode(child);
    assertConnected(child);
    assertEquals(_while, child.getCompositeActivity());
  }

  public void testAddNodeOverride() {
    _while.addNode(child);
    _while.addNode(otherChild);
    assertConnected(otherChild);
    assertDisconnected(child);
  }

  public void testRemoveNode() {
    _while.addNode(child);
    _while.removeNode(child);
    assertDisconnected(child);

    assertEquals(0, _while.getNodes().size());
  }

  public void testCondition() {
    Expression expression = new Expression();
    _while.setCondition(expression);
    assertEquals(expression, _while.getCondition());
  }

  private void assertConnected(Activity activity) {
    Collection transitions = _while.getLoop().getLeavingTransitions();
    assertTrue(transitions.contains(activity.getDefaultArrivingTransition()));

    transitions = _while.getLoop().getArrivingTransitions();
    assertTrue(transitions.contains(activity.getDefaultLeavingTransition()));

    assertEquals(_while, activity.getCompositeActivity());
    assertEquals(1, _while.getNodes().size());
  }

  private void assertDisconnected(Activity activity) {
    // validate that removed activity doesn't have incoming / outgoing
    // transitions
    assertEquals(0, activity.getArrivingTransitions().size());
    assertEquals(0, activity.getLeavingTransitions().size());
    assertEquals(null, activity.getCompositeActivity());
  }

}
