/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.FaultInstance;
import org.jbpm.bpel.graph.exe.ScopeState;

/**
 * @author Juan Cantu
 * @version $Revision: 1.1 $ $Date: 2006/10/06 01:52:29 $
 */
public class CompletingEventsTest extends AbstractStateTestCase {

  public ScopeState getState() {
    return ActiveState.COMPLETING_EVENTS;
  }

  public void testCompleted() {
    scopeInstance.completed();

    assertEquals(EndedState.COMPLETED, scopeInstance.getState());
  }

  public void testCompletedAtScope() {
    scopeInstance.completed();

    assertEquals(EndedState.COMPLETED, scopeInstance.getState());
    assertTrue(scopeCompletionLog.executed);
  }

  public void testFaulted() {
    FaultInstance faultInstance = new FaultInstance();
    scopeInstance.faulted(faultInstance);

    assertEquals(FaultingState.TERMINATING_PRIMARY_ACTIVITY,
        scopeInstance.getState());
    assertEquals(faultInstance, scopeInstance.getFaultInstance());
    assertChildrenTerminated();
  }

  public void testTerminate() {
    scopeInstance.terminate();

    assertEquals(TerminatingState.TERMINATING_PRIMARY_ACTIVITY,
        scopeInstance.getState());
    assertChildrenTerminated();
  }
}
