/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.def;

import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.persistence.db.AbstractDbTestCase;

public class ImportDbTest extends AbstractDbTestCase {

  public void testLocation() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    Import anImport = new Import();
    anImport.setLocation("aLocation");
    processDefinition.getImportDefinition().addImport(anImport);

    processDefinition = saveAndReload(processDefinition);

    anImport = (Import) processDefinition.getImportDefinition().getImports().get(0);
    assertEquals("aLocation", anImport.getLocation());
  }

  public void testNamespace() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    Import anImport = new Import();
    anImport.setNamespace("http://www.enoughisenough.org");
    processDefinition.getImportDefinition().addImport(anImport);

    processDefinition = saveAndReload(processDefinition);

    anImport = (Import) processDefinition.getImportDefinition().getImports().get(0);
    assertEquals("http://www.enoughisenough.org", anImport.getNamespace());
  }

  public void testWsdlType() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    Import anImport = new Import();
    anImport.setType(Import.Type.WSDL);
    processDefinition.getImportDefinition().addImport(anImport);

    processDefinition = saveAndReload(processDefinition);

    anImport = (Import) processDefinition.getImportDefinition().getImports().get(0);
    assertEquals(Import.Type.WSDL, anImport.getType());
  }

  public void testSchemaType() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    Import anImport = new Import();
    anImport.setType(Import.Type.XML_SCHEMA);
    processDefinition.getImportDefinition().addImport(anImport);

    processDefinition = saveAndReload(processDefinition);

    anImport = (Import) processDefinition.getImportDefinition().getImports().get(0);
    assertEquals(Import.Type.XML_SCHEMA, anImport.getType());
  }
}