/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.def;

import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.persistence.db.AbstractDbTestCase;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.3 $ $Date: 2007/05/03 12:25:56 $
 */
public class BpelProcessDefinitionDbTest extends AbstractDbTestCase {

  public void testGlobalScope() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    Scope globalScope = processDefinition.getGlobalScope();

    processDefinition = saveAndReload(processDefinition);
    globalScope = processDefinition.getGlobalScope();

    assertSame(processDefinition, globalScope.getProcessDefinition());
  }

  public void testImports() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    ImportDefinition importDefinition = processDefinition.getImportDefinition();

    processDefinition = saveAndReload(processDefinition);
    importDefinition = processDefinition.getImportDefinition();

    assertSame(processDefinition, importDefinition.getProcessDefinition());
  }

  public void testExpressionLanguage() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    processDefinition.setExpressionLanguage("xpath");

    processDefinition = saveAndReload(processDefinition);

    assertEquals("xpath", processDefinition.getExpressionLanguage());
  }

  public void testQueryLanguage() {
    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    processDefinition.setQueryLanguage("java");

    processDefinition = saveAndReload(processDefinition);

    assertEquals("java", processDefinition.getQueryLanguage());
  }
}
