/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.basic.assign;

import javax.wsdl.PortType;
import javax.xml.namespace.QName;

import junit.framework.TestCase;

import com.ibm.wsdl.PortTypeImpl;

import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.endpointref.wsa.WsaEndpointReference;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.wsdl.PartnerLinkType.Role;
import org.jbpm.bpel.wsdl.impl.PartnerLinkTypeImpl;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.1 $ $Date: 2007/03/22 13:32:55 $
 */
public class ToPartnerLinkTest extends TestCase {

  private ToPartnerLink to = new ToPartnerLink();
  private Token token;

  protected void setUp() throws Exception {
    // port type 1
    PortType portType1 = new PortTypeImpl();
    portType1.setQName(new QName("pt1"));
    // port type 2
    PortType portType2 = new PortTypeImpl();
    portType2.setQName(new QName("pt2"));
    // partner link type
    PartnerLinkType partnerLinkType = new PartnerLinkTypeImpl();
    partnerLinkType.setQName(new QName("plt"));
    // role 1
    Role role1 = partnerLinkType.createRole();
    role1.setName("r1");
    role1.setPortType(portType1);
    partnerLinkType.setFirstRole(role1);
    // role 2
    Role role2 = partnerLinkType.createRole();
    role2.setName("r2");
    role2.setPortType(portType2);
    partnerLinkType.setSecondRole(role2);
    // partner link
    PartnerLinkDefinition partnerLink = new PartnerLinkDefinition();
    partnerLink.setName("pl1");
    partnerLink.setPartnerLinkType(partnerLinkType);
    partnerLink.setMyRole(role1);
    partnerLink.setPartnerRole(role2);
    // to
    to.setPartnerLink(partnerLink);
    // process and global scope
    BpelProcessDefinition pd = new BpelProcessDefinition();
    Scope scope = pd.getGlobalScope();
    scope.addPartnerLink(partnerLink);
    // instantiate process
    token = new ProcessInstance(pd).getRootToken();
    // initialize global scope
    scope.createInstance(token).initializeData();
  }

  public void testAssign() {
    // endpoint ref
    EndpointReference endpointRef = new WsaEndpointReference();

    to.assign(token, endpointRef);
    assertSame(endpointRef, to.getPartnerLink()
        .getInstance(token)
        .getPartnerReference());
  }

}
