/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.xml;

import java.util.Iterator;

import org.w3c.dom.Element;

import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.def.LinkDefinition;
import org.jbpm.bpel.graph.struct.Flow;
import org.jbpm.bpel.xml.util.XmlUtil;

/**
 * Encapsulates the logic to create and connect process elements that make up
 * the <i>flow</i> structure.
 * @author Juan Cant
 * @version $Revision: 1.7 $ $Date: 2007/05/31 12:55:12 $
 */
public class FlowReader extends ActivityReader {

  /**
   * Loads the activity properties from the given DOM element
   */
  public Activity read(Element activityElem, CompositeActivity parent) {
    Flow flow = new Flow();
    readStandardProperties(activityElem, flow, parent);
    readFlow(activityElem, flow);
    return flow;
  }

  public void readFlow(Element flowElem, Flow flow) {
    // links
    Element linksElem = XmlUtil.getElement(flowElem, BpelConstants.NS_BPEL,
        BpelConstants.ELEM_LINKS);
    if (linksElem != null) {
      Iterator linkElemIt = XmlUtil.getElements(linksElem,
          BpelConstants.NS_BPEL, BpelConstants.ELEM_LINK);
      while (linkElemIt.hasNext()) {
        Element linkElem = (Element) linkElemIt.next();
        flow.addLink(new LinkDefinition(
            linkElem.getAttribute(BpelConstants.ATTR_NAME)));
      }
    }

    // activities
    Iterator activityElemIt = bpelReader.getActivityElements(flowElem);
    while (activityElemIt.hasNext()) {
      Element activityElem = (Element) activityElemIt.next();
      bpelReader.readActivity(activityElem, flow);
    }
  }
}
