/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.scheduler.ejbtimer;

import java.util.ArrayList;
import java.util.List;

import javax.ejb.CreateException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.svc.JbpmServiceException;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.2 $ $Date: 2007/07/20 22:46:49 $
 */
public class EjbSchedulerService implements SchedulerService {

  private final JbpmContext jbpmContext;
  private final SchedulerControl schedulerControl;

  private List timers = new ArrayList();

  private static final long serialVersionUID = 1L;
  private static final Log log = LogFactory.getLog(EjbSchedulerService.class);

  EjbSchedulerService(EjbSchedulerServiceFactory factory) {
    jbpmContext = factory.getJbpmConfiguration().getCurrentJbpmContext();
    try {
      schedulerControl = factory.getSchedulerControlHome().create();
    }
    catch (CreateException e) {
      throw new JbpmServiceException("could not create scheduler control", e);
    }
  }

  public void createTimer(Timer timer) {
    jbpmContext.getJobSession().saveJob(timer);
    timers.add(timer);
    log.debug("created jbpm timer: " + timer);
  }

  public void deleteTimersByName(String timerName, Token token) {
    jbpmContext.getJobSession().cancelTimersByName(timerName, token);
    schedulerControl.cancelTimers(timerName, token.getId());
  }

  public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
    jbpmContext.getJobSession().deleteJobsForProcessInstance(processInstance);
    schedulerControl.cancelTimers(processInstance.getId());
  }

  public void close() {
    // if transaction is marked for rollback, don't create ejb timers
    if (!jbpmContext.getServices().getTxService().isRollbackOnly()) {
      for (int i = 0, n = timers.size(); i < n; i++) {
        Timer timer = (Timer) timers.get(i);
        schedulerControl.createTimer(timer.getDueDate(), new TimerInfo(timer));
      }
    }
    // else no need to delete the jbpm timers, because changes to the database will be rolled back
  }
}
