/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import java.io.InputStream;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.transformxml2xmlsimple.test.SendJMSMessage;
import org.jboss.soa.esb.testutils.FileUtil;

/**
 * CI test for the transformXMLSimple quickstart.
 *
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class TransformXMLSimpleTest
        extends AbstractQuickstartTestCase
{
	private static final String FILE_NAME = "transformedmessageXML2Simple.log";

	public TransformXMLSimpleTest(String name)
	{
		super(name);
	}

	public void testMessage() throws Exception
	{
	    clearMessages() ;
	    sendMessage() ;
            final String[] messages = waitForMessages(1, 30000) ;
		// Make sure the file matches expected output
		final InputStream is = getClass().getClassLoader().getResourceAsStream(FILE_NAME) ;
                final String expectedString ;
                try
                {
                    expectedString = FileUtil.readStream(is);
                }
                finally
                {
                    is.close() ;
                }
                final boolean match = Helpers.compareXMLContent(expectedString, messages[0]) ;
                assertTrue("Unexpected response: " + messages[0], match) ;
	}

	public void sendMessage() throws Exception
	{
		SendJMSMessage sm = new SendJMSMessage();
        sm.setupConnection();
        sm.sendAMessage(Helpers.getQuickstartLocation("transform_XML2XML_simple/SampleOrder.xml"));
        sm.stop();
	}

   public static Test suite() throws Exception
   {
      return getDeploySetup(TransformXMLSimpleTest.class, "QuickstartMessageStoreServer.sar, transformation-simple-quickstart.esb");
   }
}
