/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.messagestore.test.SendJMSMessage;

/**
 * CI test for the messagestore quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class MessageStoreTest extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "MessageStoreTest message";

	public MessageStoreTest(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendMessage() ;
	    checkMessages(30000, JMS_MESSAGE, "Success:" + JMS_MESSAGE) ;
	}

	public void sendMessage() throws Exception {
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(JMS_MESSAGE);
		sm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(MessageStoreTest.class, "QuickstartMessageStoreServer.sar, Quickstart_messagestore.esb");
	}
}
