/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.jms;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.client.ServiceInvoker;
import junit.framework.TestCase;

import java.util.List;
import java.util.ArrayList;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MessageAugmentor extends AbstractActionPipelineProcessor {

    public static List<String> messages = new ArrayList<String>();
    private String addition;
    private String target;

    public MessageAugmentor(ConfigTree config) throws ConfigurationException {
        addition = config.getRequiredAttribute("addition");
        target = config.getRequiredAttribute("target");
    }

    public Message process(final Message message) throws ActionProcessingException {
        message.getProperties().setProperty("addition", addition);

        String[] targetTokens = target.split(":");
        if(targetTokens.length != 2) {
            TestCase.fail("Action not configured properly - 'target' service property must be in format 'category:name'.");
        }

        try {
            ServiceInvoker invoker = new ServiceInvoker(targetTokens[0], targetTokens[1]);
            invoker.deliverAsync(message);
        } catch (MessageDeliverException e) {
            TestCase.fail("Failed to create ServiceInvoker: " + e.getMessage());
        }

        messages.add(addition);

        return message;
    }
}
