/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007
 */

package org.jboss.soa.esb.eclipse.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.jboss.soa.esb.eclipse.util.ESBUtils;

/**
 * The Application Server Directory field editor.
 * 
 * @author kevin
 */
public class ASDirectoryFieldEditor extends DirectoryFieldEditor
{
    /**
     * The enabled flag.
     */
    private boolean enabled ;
    
    /**
     * Construct the Application Server Directory Field Editor.
     * @param parent The parent composite.
     */
    public ASDirectoryFieldEditor(Composite parent)
    {
        super(ESBPreferenceConstants.AS_LOCATION, "&Application Server Location:", parent);
        setEmptyStringAllowed(false) ;
        setErrorMessage("Application Server location does not specify an Application Server deployment");
    }
    
    /**
     * Check the state after a change.
     * @return true if valid, false otherwise.
     */
    protected boolean doCheckState()
    {
        if (!enabled)
        {
            return true ;
        }
        
        if (super.doCheckState())
        {
            final String esbLocation = getTextControl().getText();
            return (ESBUtils.isASLocation(esbLocation)) ;
        }
        return false ;
    }
    
    /**
     * Enable or disable the component.
     * @param enabled true if the component is enabled, false otherwise.
     * @param parent The parent composite.
     */
    public void setEnabled(final boolean enabled, final Composite parent)
    {
        this.enabled = enabled ;
        super.setEnabled(enabled, parent);
        setEmptyStringAllowed(!enabled) ;
        if (!enabled)
        {
            setStringValue("") ;
        }
        refreshValidState() ;
    }
}
