/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import static org.jboss.seam.ScopeType.EVENT;
import static org.jboss.seam.ScopeType.SESSION;

import java.io.Serializable;
import java.util.List;

import javax.persistence.EntityManager;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;

/**
 * Action listener for outjecting the complete list of {@link org.jboss.soa.esb.admin.console.transform.TransformationResource}
 * configurations managed by this instance of the console.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Name("listAllResources")
@Scope(EVENT)
public class ListAllResources implements Serializable {

	private static final long serialVersionUID = 1L;

	@In(create=true)
	private EntityManager entityManager;

	// TODO: Why can't we outject this to the EVENT context???
	@Out(scope=SESSION)
	private List<TransformationResource> allResourceConfigs;
	
	/**
	 * List all resources.
	 * <p/>
	 * Initialises the data model before it's outjected.
	 * @return
	 */
	public void list() {
		allResourceConfigs = entityManager.createQuery("from TransformationResource").getResultList();
	}
}