package org.jboss.soa.esb.monitoring.server;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import org.jboss.soa.esb.message.body.content.MessageBodyTypeNames;

public class FilerFactory {
	private static FilerFactory factory = null;
	
	/**
	 * Private constructor.
	 */
	private FilerFactory () {	
	}
	
	/**
	 * Returns the instance of FilerFactory.
	 * @return factory
	 */
	public static FilerFactory getInstance() {
		if (factory == null) {
			factory = new FilerFactory();
		}
		return factory;
	}
	
	/**
	 * Get the appropriate filer depending on the command type.
	 * @param filerType filer type
	 * @return filer
	 */
	public Filer getFiler(String filerType) {
		if (MessageBodyTypeNames.STATISTICS_RESPONSE.equals(filerType)) {
			return new DataFiler();
		} else if (MessageBodyTypeNames.OPERATIONS_RESPONSE.equals(filerType)) {
			return new OperationsFiler();
		} else if (MessageBodyTypeNames.INVOKER_RESPONSE.equals(filerType)) {
			return new InvokerFiler();
		}
		return null;
	}
}
