/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring.pojo;

import java.util.Date;

/**
 * POJO storing a JMX attribute's data on a specific server at a specific
 * time.   The JMXData object stores the related attribute, the server name,
 * the collection date and the data.    Only one of the
 * timevalue/countvalue/textvalue are set - depending on what the type of the
 * object is.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class JMXOperationResult implements java.io.Serializable {
	
	private static final long serialVersionUID = -1862113692118964270L;
	private Long id;
	private JMXOperation operation;
	private String servername;
	private Date statdate;
	private String result;

    /**
     * Constructor.
     */
    public JMXOperationResult() {
    }

    /**
     * Constructor.
     * @param attribute attribute
     * @param server server name 
     * @param statdate statistic date
     * @param timevalue time value
     * @param countvalue count value 
     * @param textvalue test value
     */
    public JMXOperationResult(JMXOperation operation, String servername, Date statdate, String result) {
       this.operation = operation;
       this.servername = servername;
       this.statdate = statdate;
       this.result = result;
    }
   
    /**
     * Id getter.
     * @return id
     */
    public Long getId() {
        return this.id;
    }
    
    /**
     * Id mutator. 
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }
    
    /**
     * Attribute name getter.
     * @return attribute name
     */
    public JMXOperation getOperation() {
        return this.operation;
    }
    
    /**
     * Attribute name mutator.
     * @param attribute attribute name
     */
    public void setOperation(JMXOperation operation) {
        this.operation = operation;
    }
    
    /**
     * Server name getter.
     * @return server name
     */
    public String getServername() {
    	return servername;
    }
    
    /**
     * Server name mutator.
     * @param f_server server name
     */
    public void setServername(String f_servername) {
    	servername = f_servername;
    }
   
    
    /**
     * Server name getter.
     * @return server name
     */
    public String getResult() { 
    	return result;
    }
    
    /**
     * Server name mutator.
     * @param f_server server name
     */
    public void setResult(String f_result) {
    	result = f_result;
    }
    
    /**
     * Stat date getter.
     * @return stat date
     */
    public Date getStatdate() {
        return this.statdate;
    }
    
    /**
     * Stat date mutator.
     * @param statdate stat date
     */
    public void setStatdate(Date statdate) {
        this.statdate = statdate;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
    	return "id [" + id + "] time[" + statdate + "] result[" + result + "] "
    		+ "operation[" + operation + "]";
    }

}


