/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.monitoring.client;

import java.io.IOException;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.message.body.content.ServiceControlCommand;

public class Invoker {
	Logger logger = Logger.getLogger(Invoker.class);
	private MBeanServerConnection server;
	
	public Invoker() {
                server = MBeanServerLocator.locateJBoss();      
	}
	
	public Object invoke(ServiceControlCommand obean) {
		ObjectName on = null;
		try {
			on = new ObjectName(obean.getObjectName());
			Object result = server.invoke(on, obean.getOperation(), null, null);
			return result;
		} catch (MalformedObjectNameException e) {
			logger.error("", e);
		} catch (NullPointerException e) {
			logger.error("", e);
		} catch (InstanceNotFoundException e) {
			logger.error("", e);
		} catch (MBeanException e) {
			logger.error("", e);
		} catch (ReflectionException e) {
			logger.error("", e);
		} catch (IOException e) {
			logger.error("", e);
		}
		return null;
	}
}
