/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring;

/**
 * CastingHelper is a helper class which returns Integers/Floats/Doubles/Longs
 * based on the type that a JMXAttribute is identifying itself as.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class CastingHelper {
	public static Integer getInteger(Object obj) {
		if (obj instanceof String) {
			try {
				return (new Integer((String) obj));
			} catch (Exception e) {
				return null;
			}
		} else if (obj instanceof Integer) {
			return (Integer) obj;
		} 
		
		return null;
	}
	
	public static Float getFloat(Object obj) {
		if (obj instanceof String) {
			try {
				return (new Float((String) obj));
			} catch (Exception e) {
				return null;
			}
		} else if (obj instanceof Float) {
			return (Float) obj;
		}
		return null;
	}
	
	public static Double getDouble(Object obj) {
		if (obj instanceof String) {
			try {
				return (new Double((String) obj));
			} catch (Exception e) {
				return null;
			}
		} else if (obj instanceof Double) {
			return (Double) obj;
		}
		return null;
	}
	
	public static Long getLong(Object obj) {
		if (obj instanceof String) {
			try {
				return (new Long((String) obj));
			} catch (Exception e) {
				return null;
			}
		} else if (obj instanceof Long) {
			return (Long) obj;
		}
		return null;
	}
	
	public static Object castObject(String type, Object data) {
		if (type.equals("int") || type.equals("java.lang.Integer")) {
			return CastingHelper.getInteger(data);
		} else if (type.equals("float") || type.equals("java.lang.Float")) {
			return CastingHelper.getFloat(data);
		} else if (type.equals("double") || type.equals("java.lang.Double")) {
			return CastingHelper.getDouble(data);
		} else if (type.equals("long") || type.equals("java.lang.Long")) {
			return CastingHelper.getLong(data);
		} else {
			return data;
		}
	}
}
