<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ page session="true" %>
<%@ page import="
	java.util.List,
	org.hibernate.Session,
	org.hibernate.Transaction,
	org.jboss.soa.esb.monitoring.MonitoringSessionFactory,
	org.jboss.soa.esb.monitoring.pojo.*,
	org.jboss.soa.esb.monitoring.server.StatisticsHelper,
	org.jboss.soa.esb.monitoring.server.OperationsHelper
"%>
<html>
<head>
   <title>JBoss ESB Management Console</title>
   <link rel="stylesheet" href="style_master.css" type="text/css">
   <meta http-equiv="cache-control" content="no-cache">
</head>
<body>
   <table>
      <tr>
         <td><img src="images/logo.gif" align="left" border="0" alt="JBoss"></td>
         <td valign="middle">         
         <h1>JBoss ESB Management Console</h1>
         </td>
      </tr>
      </table>
      <table cellpadding="5">
      <tr>
      	<td><a href="/jbossesb/">Monitoring</a></td>
      	<td><a href="/jbossesb/operations.jsp">Back to Operations list</a></td>
      </tr>
   </table>
<hr>
	<form action="manage.jsp" method="post">
	<nobr>
 	Current polling interval is <b><code><%=StatisticsHelper.getCollectionInterval()%></code></b> minutes.
	  <input type="submit" value="Collect Operations"/>
	</nobr>
	</form>
<%
Session sess = null;
Transaction tx = null;
try {
	sess = MonitoringSessionFactory.getInstance().openSession();
	tx = sess.beginTransaction();
	List serverNames = OperationsHelper.getServerNames(sess);
	for (int i = 0; i<serverNames.size(); i++) {
		String serverName = (String) serverNames.get(i);
%>
<hr>
	<h1><code><%=serverName%></code></h1>
<% 
		List results = OperationsHelper.getOperationResults(sess, serverName);
		for (int j = 0; j < results.size(); j++) {
			JMXOperationResult jmxor = (JMXOperationResult) results.get(j);
		%>
		<li><b><%=jmxor.getStatdate()%></b></li>
		<ul>
			<li><b>Result:</b> <%=jmxor.getResult() %>
			<li><b>Object name:</b> <%=jmxor.getOperation().getObjectname() %>
			<li><b>Operation:</b> <%=jmxor.getOperation().getReturntype()%> <%=jmxor.getOperation().getOperation() %>
		</ul>
		<% 
	}

}

	if (serverNames.size() == 0) {
		%>
		No operations found in database.
		<% 
	}
} catch (Exception e) {
	e.printStackTrace();
} finally {
	if (tx.isActive()) {
		tx.rollback();
	} 
	tx = null;
	
	sess.flush();
	sess.close();
	sess = null;
}
%>
</body>
</html>
