package model.services {
	
	import model.common.Namespaces;
	
	import mx.collections.ArrayCollection;
	import mx.controls.List;
	
	/**
	 * A service to which messages may be routed.
	 */
	[Bindable]
	public class Service {
		
		/** Category in registry */
		public var category:String;
		
		/** Name in registry */
		public var name:String;
		
		/** Service description */
		public var description:String;
		
		/** Listeners for the service */
		public var listeners:ArrayCollection = new ArrayCollection();
		
		/** Action chain for the service */
		public var actions:ArrayCollection = new ArrayCollection();
		
		/** QName for the providers element */
		private static const LISTENERS:QName = new QName(Namespaces.JESB, "listeners");
		
		/** QName for the providers element */
		private static const ACTIONS:QName = new QName(Namespaces.JESB, "actions");
		
		/**
		 * Create a Service from XML.
		 */
		public function Service(xml:XML = null) {
			if (xml != null) {
				this.category = xml.@category;
				this.name = xml.@name;
				this.description = xml.@description;
				this.listeners = Listener.getListeners(XML(xml.elements(LISTENERS)));
				this.actions = Action.getActions(XML(xml.elements(ACTIONS)));
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			var xml:String = "<service ";
			xml = xml + " category=\"" + this.category + "\" ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " description=\"" + this.description + "\" ";
			xml = xml + ">";
			xml = xml + "<listeners>";
			for each (var listener:Listener in this.listeners) {
				xml = xml + listener.getXmlString();
			}
			xml = xml + "</listeners>";
			xml = xml + "<actions>";
			for each (var action:Action in this.actions) {
				xml = xml + action.getXmlString();
			}
			xml = xml + "</actions>";
			xml = xml + "</service>";
			return xml;
		}
		
		/**
		 * Get the fully-qualified service name.
		 */
		public function get fullName():String {
			return category + ":" + name;
		}
		
		/**
		 * Load a list of services from XML.
		 */
		public static function getServices(xml:XML):ArrayCollection {
			var results:ArrayCollection = new ArrayCollection();
			for each (var serviceXml:XML in xml.children()) {
				results.addItem(new Service(serviceXml));					
			}
			return results;
		}
	}
}