package model.services {
	
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	import model.JBossESBModel;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import flash.events.IOErrorEvent;
	
	/**
	 * Manages the list of action templates.
	 */
	public class ActionTemplateManager {
		
		/** Injected model reference */
		private var _jmodel:JBossESBModel;

		/** Loads action templates via HTTP */
		protected var loader:URLLoader;
			
		/** URL called to download the action templates from the server */
		protected static const TEMPLATES_SUFFIX:String = "esbconfig/download/actions";
	
		/**
		 * Create the template manager.
		 */
		public function ActionTemplateManager() {
			this.loader = new URLLoader();
			this.loader.addEventListener(Event.COMPLETE, receivedTemplates);
			this.loader.addEventListener(IOErrorEvent.IO_ERROR, ioError);
		}
		
		/**
		 * Getter for ESB model.
		 */
		public function get jmodel():JBossESBModel {
			return _jmodel;
		}
		
		/**
		 * Setter for ESB model.
		 */
		public function set jmodel(model:JBossESBModel):void {
			this._jmodel = model;
			refresh();
		}
		
		/**
		 * Refresh the list of templates.
		 */
		public function refresh():void {
			var request:URLRequest = new URLRequest();
			request.url = jmodel.serverBaseUrl + TEMPLATES_SUFFIX;
			this.loader.load(request);
		}
		
		/**
		 * Called when template data has been loaded.
		 */
		protected function receivedTemplates(event:Event):void {
			var xml:XML = new XML(loader.data);
			jmodel.actionTemplates = Action.getActions(xml);
		}
		
		/**
		 * Called on IO error loading templates.
		 */
		protected function ioError(event:IOErrorEvent):void {
			Alert.show(event.text, "Unable to Load Action Templates");
		}
	}
}