package model.providers {
	
	/**
	 * Provider that loads data from an FTP site.
	 */
	[Bindable]
	public class FtpProvider extends Provider {
		
		/** FTP host name */
		public var hostName:String;
		
		/**
		 * Create a FtpProvider from XML.
		 */
		public function FtpProvider(xml:XML = null) {
			super(xml);
			if (xml != null) {
				this.hostName = xml.@hostname;
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<ftp-provider ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " hostname=\"" + this.hostName + "\" ";
			xml = xml + ">";
			for each (var bus:Bus in this.buses) {
				xml = xml + bus.getXmlString();
			}
			xml = xml + "</ftp-provider>";
			return xml;
		}
	}
}