package model.providers {
	
	/**
	 * Provider that monitors a file system.
	 */
	[Bindable]
	public class FileProvider extends Provider {
		
		/**
		 * Create a FileProvider from XML.
		 */
		public function FileProvider(xml:XML = null) {
			super(xml);
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<fs-provider ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + ">";
			for each (var bus:Bus in this.buses) {
				xml = xml + bus.getXmlString();
			}
			xml = xml + "</fs-provider>";
			return xml;
		}
	}
}