package org.jboss.soa.esb.services.soapui.orderprocessing;

import java.io.Serializable;

/**
 * OrderStatus is the serialized object that this example is based around.   It
 * contains a product name, the quantity of that product ordered, and the
 * price per unit of the product.    It is serializable so that it can
 * be bundled up in a message, and the JSPs
 *
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.2
 */
public class OrderStatus implements Serializable {

	private static final long serialVersionUID = 0L;
	private Long id;
	private String comment;
	private int returnCode;
	public static final int SUCCESS = 1;
	public static final int FAIL = 1;

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	public int getReturnCode() {
		return returnCode;
	}
	public void setReturnCode(int returnCode) {
		this.returnCode = returnCode;
	}


}
