/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.cmd;

import java.util.List;
import java.util.Map;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.jbpm.Constants;
import org.jboss.soa.esb.services.jbpm.JBpmObjectMapper;
import org.jboss.soa.esb.services.jbpm.Mapping;
import org.jboss.soa.esb.services.jbpm.Constants.OpCode;

/**
 *
 * Implementation of a message preprocessor to obtain data from a process instance 
 * from the action configuration XML
 * 
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a> 
 */
public class SignalFacade extends MessageFacade
{
	public OpCode getOpCode() { return Constants.OpCode.SignalCommand; }

	public SignalFacade(ConfigTree config) throws ConfigurationException
	{
		_transition		= config.getAttribute(Constants.TRANSITION_NAME_TAG);
        _esbToBpm       = ConfigUtil.getMappingConfig(config);
	}
	
	public void setJBPMContextParameters(Message message) 
	{
		Body body = message.getBody();
		if (null!=_transition)
			body.add(Constants.TRANSITION_NAME, _transition);
        Map<String,Object> variableMap = _mapper.mapFromEsbMessageToJBpmMap(message, _esbToBpm);
        if (null!=variableMap)
            body.add(Constants.VARIABLE_VALUES, variableMap);
	}
    
    String          _transition;
    List<Mapping>   _esbToBpm;
    JBpmObjectMapper _mapper = new JBpmObjectMapper();
}
