/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.esb.quickstarts.bpel;

import com.activebpel.shipping.Shipping;
import com.activebpel.shipping.ShippingResponse;
import com.activebpel.shipping.ShippingRequest;

import javax.jws.WebService;
import javax.jws.WebMethod;
import javax.jws.soap.SOAPBinding;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.rmi.RemoteException;

/**
 * Shipper Service wrapper webservice.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@WebService(name = "ShippingPortType", targetNamespace = ShipperService.Namespace)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, parameterStyle = SOAPBinding.ParameterStyle.BARE)
public class ShipperService implements Shipping {

    public static final String Namespace = "http://org.jboss.esb/quickstarts/bpel/ABI_Shipping";

    private Shipping shipping = null;

    public ShipperService() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        } catch (NamingException e) {
            throw new RuntimeException("Unable to create JNDI context.", e);
        }
        try {
            shipping = (Shipping) ctx.lookup("ShippingBean/remote");
        } catch (NamingException e) {
            throw new RuntimeException("Unable to lookup Shipping Service Bean.", e);
        }
    }

    @WebMethod(operationName = "shippingRequest")
    public ShippingResponse shipOrder(ShippingRequest shippingRequest) throws RemoteException {
        System.out.println("****** ShipperService received shipping request [" + shippingRequest + "]");
        return shipping.shipOrder(shippingRequest);
    }
}
