/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.util;

import junit.framework.TestCase;

import java.io.*;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class FileUtilUnitTest extends TestCase {

    private File tmpDir = new File(System.getProperty("user.dir")) ;
    private File dir1 = new File(tmpDir, FileUtilUnitTest.class.getSimpleName());
    private File dir2 = new File(tmpDir, FileUtilUnitTest.class.getSimpleName());
    private File file1 = new File(dir1, "file1");
    private final File file2 = new File(dir2, "file2");

    protected void setUp() throws Exception {
        cleanupTemps();
        dir1.mkdirs();
        dir2.mkdirs();
    }

    protected void tearDown() throws Exception {
        cleanupTemps();
    }

    public void test_moveTo_good() throws IOException {
        writeToFile(file1, "Hi there!");

        assertTrue(file1.exists());
        assertTrue(!file2.exists());

        assertTrue(FileUtil.moveFile(file1, file2));

        assertTrue(!file1.exists());
        assertTrue(file2.exists());

        assertEquals("Hi there!", FileUtil.readTextFile(file2));        
    }

    public void test_moveTo_from_doesnt_exists() throws IOException {
        assertTrue(!FileUtil.moveFile(file1, file2));
    }

    public void test_moveTo_to_exists() throws IOException {
        file2.createNewFile();
        assertTrue(!FileUtil.moveFile(file1, file2));
    }

    private void cleanupTemps() {
        file1.delete();
        file2.delete();
        dir1.delete();
        dir2.delete();
    }

    public static void writeToFile(File file, String str) throws IOException {
        Writer writer = new FileWriter(file);
        writer.write(str);
        writer.close();
    }
}
