package org.jboss.soa.esb.testutils;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.Statement;

import org.apache.log4j.Logger;
import org.hsqldb.Server;
/**
 * Utility to start and stop a hsql Database.
 * 
 * @author <a href="mailto:kurt.stam@jboss.com">Kurt Stam</a>
 *
 */
public class HsqldbUtil 
{
	private static Logger log = Logger.getLogger( HsqldbUtil.class );
	
	final private static String THREAD_NAME = "hypersonic-unittest";
	/**
	 * Starts the hsql database in it's own thread. 
	 * Don't forget to shut it down when you're done.
	 * 
	 * @param databaseFile - i.e. build/hsqltestdb
	 * @param databaseName - i.e. jbossesb
	 * @throws Exception
	 */
	public static void startHsqldb(final String databaseFile,
			final String databaseName) throws Exception 
	{
		// Start DB in new thread, or else it will block us
		Thread serverThread = new Thread(THREAD_NAME) {
			public void run() {
				try {
					// Start server
					Server server = new Server();
					Logger targetLogger = Logger.getLogger( "org.hsqldb" );
					server.setLogWriter( new PrintWriter( 
							new StdOut2Log4jFilter( server.getLogWriter(), log, targetLogger.getEffectiveLevel() )) );
					server.setDatabasePath( 0, databaseFile );
					server.setDatabaseName( 0, databaseName );
					server.setNoSystemExit( true );
					server.setSilent( true );
					server.start();
				} catch (Exception e) {
					log.error( e );
				}
				//log.error("Failed to start database", e);
			}
		};
		serverThread.run();
	}
	/**
	 * 
	 * @param url
	 * @param username
	 * @param password
	 * @throws Exception
	 */
	public static void stopHsqldb(String url, String username, String password) throws Exception {
		java.sql.Connection connection = DriverManager.getConnection(
				url, username, password);
		Statement statement = connection.createStatement();
		String shutdownCommand = "SHUTDOWN COMPACT";
		statement.executeQuery(shutdownCommand);
	}

	
}
