/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.tests.filter;

import java.net.URI;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.BeforeClass;
import org.junit.Test;

import com.arjuna.common.util.propertyservice.PropertyManager;

public class TraceFilterUnitTest
{
    @BeforeClass
    public static void setUp () throws Exception
    {
	PropertyManager pm = ModulePropertyManager
		.getPropertyManager(ModulePropertyManager.FILTER_MODULE);
	pm.setProperty("org.jboss.soa.esb.filter.0",
		"org.jboss.internal.soa.esb.message.filter.TraceFilter");
	pm.setProperty(Environment.MESSAGE_TRACE, "on");
    }

    public static junit.framework.Test suite ()
    {
	return new JUnit4TestAdapter(TraceFilterUnitTest.class);
    }

    @Test
    public void testTracing () throws Exception
    {
	Message msg = MessageFactory.getInstance().getMessage();
	
	msg.getHeader().getCall().setTo(new FTPEpr("ftp://foo.bar"));
	msg.getHeader().getCall().setReplyTo(new HTTPEpr("http://bar.foo"));
	msg.getHeader().getCall().setAction(new URI("urn:dowork"));
	msg.getBody().add("Hello World".getBytes());
	msg.getHeader().getCall().setMessageID(new URI("urn:foo/bar/1234"));

	Message output = FilterManager.getInstance().doOutputWork(msg, null);

	Assert.assertNotNull(output);
	
	Message input = FilterManager.getInstance().doInputWork(msg, null);

	Assert.assertNotNull(input);
    }
}
