/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.routing.cbr;

import org.jboss.soa.esb.services.routing.MessageRouterException;

import junit.framework.TestCase;

/**
 * Test to verify that the CBR factory throws an exception on null
 * being passed to it and success on a valid CBR classname.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 */
public class ContentBasedRouterFactoryUnitTest extends TestCase {
    //public static final String DEFAULT_CBR_CLASS = "org.jboss.internal.soa.esb.services.routing.cbr.JBossRulesRouter";
	public static final String DEFAULT_CBR_CLASS = "org.jboss.soa.esb.services.routing.cbr.MockRouter";
	
	public void testCBRFactory() {
		// Test for exception
		try {
			@SuppressWarnings("unused")
			ContentBasedRouter router = ContentBasedRouterFactory.getRouter(null);
			fail("Tried to create a ContentBasedRouter with a null class name,"
					+ "should have thrown an exception.");
		} catch (MessageRouterException e) {
		}
		
		// Test for successful creation of CBR instance
		try { 
			ContentBasedRouter router = ContentBasedRouterFactory.getRouter(DEFAULT_CBR_CLASS);
			if (router == null) {
				fail("CBR returned should not be null.");
			}
		} catch (MessageRouterException me) {
			me.printStackTrace();
			fail(me.getMessage());
		}
	}

}
