/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * (C) 2005-2006
 *  
 */
package org.jboss.soa.esb.persistence.manager;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.common.tests.MockDataSource;
import org.mockejb.jndi.MockContextFactory;

/**
 * Test the Standalone and the J2EE Connection Managers.
 * @author tcunning@redhat.com
 */
public class ConnectionManagerUnitTest extends BaseTest {
    private static final String JEE_CONNECTIONMGR_CLASS = "org.jboss.internal.soa.esb.persistence.manager.J2eeConnectionManager";
    private static final String STANDALONE_CONNECTIONMGR_CLASS = "org.jboss.internal.soa.esb.persistence.manager.StandaloneConnectionManager";
    private static final Logger logger = Logger.getLogger(ConnectionManagerFactoryUnitTest.class);
	
	protected void setUp() throws Exception {
        MockContextFactory.setAsInitial();
    }
	
	public void testJ2EEConnectionManager() {
		Context ctx = null;
		com.arjuna.common.util.propertyservice.PropertyManager pm = ModulePropertyManager.getPropertyManager(ModulePropertyManager.DBSTORE_MODULE);
		pm.setProperty(Environment.MSG_STORE_DB_DATASOURCE_NAME, "datasource");
		pm.setProperty(Environment.MSG_STORE_DB_CONN_MANAGER, JEE_CONNECTIONMGR_CLASS);
   
    	try {
    		ctx = new InitialContext();
    		MockDataSource mds = new MockDataSource(this);
    		String dataSourcename = Configuration.getStoreDBDatasourceName();
    		ctx.rebind(dataSourcename, mds);
    		
    	} catch (NamingException e) {
    		e.printStackTrace();
    		logger.debug("", e);
    		fail(e.getMessage());
    	} catch (Exception e) {
			logger.debug("", e);
    		fail(e.getMessage());		
    	}
		
		try {
			ConnectionManager cmf = ConnectionManagerFactory.getConnectionManager();
			@SuppressWarnings("unused")
			ConnectionManager test = cmf.getInstance();
			Connection conn = cmf.getConnection();
			if (conn == null) {
				fail("Connection returned by StandaloneConnectionManager should not be null");
			}
		} catch (ConnectionManagerException e) {
			logger.debug("", e);
			fail(e.getMessage());
		} catch (SQLException e) {
			logger.debug("", e);
			fail(e.getMessage());
		}	
	}
	
	public void testStandaloneConnectionManager() {
		Context ctx = null;
		com.arjuna.common.util.propertyservice.PropertyManager pm = ModulePropertyManager.getPropertyManager(ModulePropertyManager.DBSTORE_MODULE);
		pm.setProperty(Environment.MSG_STORE_DB_DATASOURCE_NAME, "datasource");
		pm.setProperty(Environment.MSG_STORE_DB_CONN_MANAGER, STANDALONE_CONNECTIONMGR_CLASS);
		pm.setProperty(Environment.MSG_STORE_DB_POOL_MAX_SIZE, "1");
		pm.setProperty(Environment.MSG_STORE_DB_POOL_MIN_SIZE, "1");
		pm.setProperty(Environment.MSG_STORE_DB_POOL_INITIAL_SIZE, "1");
		pm.setProperty(Environment.MSG_STORE_DB_POOL_TIMEOUT_MILLIS, "20000");
		
    	try {
    		ctx = new InitialContext();
    		MockDataSource mds = new MockDataSource(this);
    		String dataSourcename = Configuration.getStoreDBDatasourceName();
    		ctx.rebind(dataSourcename, mds);
    		
    	} catch (NamingException e) {
    		e.printStackTrace();

			logger.debug("", e);
    		fail(e.getMessage());
    	} catch (Exception e) {
			logger.debug("", e);
    		fail(e.getMessage());		
    	}
		
		try {
			ConnectionManager cmf = ConnectionManagerFactory.getConnectionManager();
			@SuppressWarnings("unused")
			ConnectionManager test = cmf.getInstance();
		} catch (ConnectionManagerException e) {
			logger.debug("", e);
			fail(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}
}
