/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import junit.framework.TestCase;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.NotificationManager;

/**
 * NotifyUtil unit tests.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class NotifyUtilUnitTest extends TestCase
{

	public void test_NotifyUtil ()
	{
		ConfigTree rootEl = new ConfigTree("rootEl");

		addNotificationConfig(rootEl, "message1", "ok");
		addNotificationConfig(rootEl, "message2", "err");
		addNotificationConfig(rootEl, "message3", "ok");
		addNotificationConfig(rootEl, "message4", "err");

		TestNotificationHandler handler = new TestNotificationHandler();
		NotifyUtil.notifyOK(handler, rootEl, "somemessage", new HashMap());
		assertEquals(2, handler.messages.size());
		assertEquals("message1 - somemessage", handler.messages.get(0));
		assertEquals("message3 - somemessage", handler.messages.get(1));

		handler.messages.clear();
		NotifyUtil.notifyError(handler, rootEl, "somemessage", new HashMap(),
				new Exception("test"));
		assertEquals(3, handler.messages.size());
		assertTrue(handler.messages.get(0).startsWith("somemessage"));
		assertTrue(handler.messages.get(1).startsWith("message2 - somemessage"));
		assertTrue(handler.messages.get(2).startsWith("message4 - somemessage"));
	}

	private void addNotificationConfig (ConfigTree rootEl, String message,
			String type)
	{
		ConfigTree notifEl = new ConfigTree(NotificationList.ELEMENT, rootEl);
		notifEl.setAttribute("message", message);
		notifEl.setAttribute(NotificationList.TYPE, type);
	}

	private class TestNotificationHandler implements NotificationManager
	{
		private List<String> messages = new ArrayList<String>();

		public void sendNotifications (ConfigTree p_oP, Serializable p_o)
				throws NotificationException
		{
			messages.add(p_oP.getAttribute("message") + " - " + p_o);
		}

		public void sendNotifications (Serializable p_o) throws NotificationException
		{
			messages.add(p_o.toString());
		}
	}
}
