/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

import junit.framework.TestCase;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.Email;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;

/**
 * NotifyEmail unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class NotifyEmailUnitTest extends TestCase {

	public void test_NotifyEmail() throws Exception {
		ConfigTree emailMessageEl = new ConfigTree("email");
		
		emailMessageEl.setAttribute(Email.FROM, "a.b@c.com");
		emailMessageEl.setAttribute(Email.SENDTO, "d.e@f.com");
		emailMessageEl.setAttribute(Email.COPYTO, "g.h@i.com");
		emailMessageEl.setAttribute(Email.MESSAGE, "Hi there!!!");
		
		NotifyEmail ne = new TestNotifyEmail(emailMessageEl, "Hi there!!!\nHello");
        Message message = MessageFactory.getInstance().getMessage(MessageType.JBOSS_XML);
        message.getBody().add("Hello".getBytes());
		ne.sendNotification(message);
	}

        public void test_NotifyEmailNoMessage() throws Exception {
                ConfigTree emailMessageEl = new ConfigTree("email");
                
                emailMessageEl.setAttribute(Email.FROM, "a.b@c.com");
                emailMessageEl.setAttribute(Email.SENDTO, "d.e@f.com");
                emailMessageEl.setAttribute(Email.COPYTO, "g.h@i.com");
                
                NotifyEmail ne = new TestNotifyEmail(emailMessageEl, "Hello");
        Message message = MessageFactory.getInstance().getMessage(MessageType.JBOSS_XML);
        message.getBody().add("Hello".getBytes());
                ne.sendNotification(message);
        }
	
	private class TestNotifyEmail extends NotifyEmail {
	        private final String message ;
		public TestNotifyEmail(ConfigTree p_oP, final String message) throws Exception {
			super(p_oP);
			this.message = message ;
		}
		protected void sendEmailNotification(ConfigTree messageParams) throws AddressException, MessagingException {
			assertEquals(message, messageParams.getAttribute(Email.MESSAGE));
		}		
	}
}
