/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.gateway;

import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.persist.JdbcCleanConn;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

public class SqlTableGatewayListenerUnitTest extends BaseTest
{
	private Logger log = Logger
			.getLogger( SqlTableGatewayListenerUnitTest.class );
	
	public SqlTableGatewayListenerUnitTest ()
	{
	}
	
	public void setUp()
	{
		try
		{
			MockRegistry.install();
			Statement stmt = getDbConnection().createStatement();

			try
			{
				stmt.executeUpdate("DROP TABLE esb_messages");
			}
			catch (Exception e)
			{
				// Ignore
			}

			stmt.executeUpdate("CREATE TABLE esb_messages (message_id varchar NOT NULL, message varchar, status varchar, insert_timestamp bigint, CONSTRAINT pkey_esb_messages PRIMARY KEY (message_id))");
		}
		catch (SQLException ex)
		{
			log.error(ex);

			fail();
		}
	}
	public void tearDown()
	{
		MockRegistry.uninstall();
	}
	
	public void testGateway () throws Exception
	{
		ConfigTree tree = new ConfigTree("test");

		tree.setAttribute(JDBCEpr.URL_TAG, "jdbc:postgresql://myhost:5432/testDB");
		tree.setAttribute(JDBCEpr.POST_DEL_TAG, "true");
		tree.setAttribute(JDBCEpr.ERROR_DEL_TAG, "true");
		tree.setAttribute(JDBCEpr.DRIVER_TAG, "org.postgresql.Driver");
		tree.setAttribute(JDBCEpr.TIMESTAMP_COLUMN_TAG, "insert_timestamp");
		tree.setAttribute(JDBCEpr.MESSAGE_ID_COLUMN_TAG, "message_id");
		tree.setAttribute(JDBCEpr.PASSWORD_TAG, "secret");
		tree.setAttribute(JDBCEpr.STATUS_COLUMN_TAG, "status");
		tree.setAttribute(JDBCEpr.TABLE_NAME_TAG, "testtable");
		tree.setAttribute(JDBCEpr.USERNAME_TAG, "joe");
		tree.setAttribute(ListenerTagNames.POLL_LATENCY_SECS_TAG, "abcde");
		tree.setAttribute("target-service-category", "Example");
		tree.setAttribute("target-service-name", "Test");
		tree.setAttribute("gatewayClass", "org.jboss.soa.esb.listeners.gateway.JdbcTableGatewayListener");
		
		SqlTableGatewayListener gateway = new SqlTableGatewayListener(tree);
		
		try
		{
			gateway.resolveComposerClass();
		}
		catch (ConfigurationException ex)
		{
			fail();
		}
		
		boolean exception = false;
				
		tree = new ConfigTree("test");

		tree.setAttribute(JDBCEpr.URL_TAG, getDbUrl());
		tree.setAttribute(JDBCEpr.POST_DEL_TAG, "true");
		tree.setAttribute(JDBCEpr.ERROR_DEL_TAG, "true");
		tree.setAttribute(JDBCEpr.DRIVER_TAG, getDbDriver());
		tree.setAttribute(JDBCEpr.TIMESTAMP_COLUMN_TAG, "insert_timestamp");
		tree.setAttribute(JDBCEpr.MESSAGE_ID_COLUMN_TAG, "message_id");
		tree.setAttribute(JDBCEpr.PASSWORD_TAG, getDbPassword());
		tree.setAttribute(JDBCEpr.STATUS_COLUMN_TAG, "status");
		tree.setAttribute(JDBCEpr.TABLE_NAME_TAG, "esb_messages");
		tree.setAttribute(JDBCEpr.USERNAME_TAG, getDbUser());
		tree.setAttribute(ListenerTagNames.POLL_LATENCY_SECS_TAG, "1000");
		tree.setAttribute("target-service-category", "Example");
		tree.setAttribute("target-service-name", "Test");
		tree.setAttribute("gatewayClass", "org.jboss.soa.esb.listeners.gateway.JdbcTableGatewayListener");
		tree.setAttribute(ListenerTagNames.SQL_SELECT_FIELDS_TAG, "esb_messages");
		
		exception = false;
		
		try
		{
			gateway = new SqlTableGatewayListener(tree);
		}
		catch (ConfigurationException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
		
		tree.setAttribute(ListenerTagNames.SQL_SELECT_FIELDS_TAG, "*");
		
		gateway = new SqlTableGatewayListener(tree);
		
		try
		{
			JdbcCleanConn conn = gateway.getDbConn();
			gateway.prepareStatements();
		}
		catch (RuntimeException ex)
		{
			log.error(ex);
			
			fail();
		}
		
		gateway.resolveComposerClass();
		
		exception = false;
		
		try
		{
			gateway.doInitialise();
		}
		catch (ManagedLifecycleException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
	
		gateway.pollForCandidates();
		
		gateway.doThreadedDestroy();
		
		gateway.changeStatusToDone();
		
		try
		{
			gateway.deleteCurrentRow();
		}
		catch (IllegalStateException ex)
		{
			fail();
		}
	}
	
}
