/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters;


import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.ActionUtils;
import org.jboss.soa.esb.actions.MockPojoAction;
import org.jboss.soa.esb.actions.MockPojoAction.MockPojo;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Assert;
import org.junit.Test;


/**
 * 
 * @author danielmarchant
 *
 */
public class ObjectInvokeTest {

	@Test
	public void testObjectInvoke() throws Exception {
		
	     MockPojo pojoObj = new MockPojo();
	     pojoObj.name="Hello";
	     String name = pojoObj.name;

         MockPojoAction.MockPojo pojo = ( MockPojoAction.MockPojo ) test_invoke(MockPojoAction.class.getName(), "doPojoAction", pojoObj);
		
	     Assert.assertNotNull(pojo.name);
	     Assert.assertNotSame(" Process didn't work " , name,pojo.name);
	}
	
    //@Test
    public void test_unknownProcesor() throws Exception {
        test_invoke("com.acme.UnknownProcessor", "doPojoAction", new MockPojo());
        // Expected a ConfigurationException of some sort here!!
    }

    // @Test
    public void test_invalidMethodName() throws Exception {
        test_invoke(MockPojoAction.class.getName(), "goPojoAction", new MockPojo());
    }

    @Test
    public void test_invalidProcessorParamType() throws Exception {
        try {
            test_invoke(MockPojoAction.class.getName(), "doPojoAction", new String(""));
            Assert.fail("Expected ActionProcessingException");
        } catch(ActionProcessingException e) {
            Assert.assertEquals("Invalid arguments for class-processor [ org.jboss.soa.esb.actions.MockPojoAction] for Action Processor: ObjectInvoke", e.getMessage());
        }
    }

    private Object test_invoke(String className, String methodName, Object param) throws ActionProcessingException {
        ConfigTree config = new ConfigTree("config");

        config.setAttribute("class-processor", className);
        config.setAttribute("class-method", methodName);

        Message oMsg = MessageFactory.getInstance().getMessage();
        
        oMsg.getBody().add(param);

        ObjectInvoke objectInvoke = new ObjectInvoke(config);
        objectInvoke.process(oMsg);

        return oMsg.getBody().get();
    }
}
