/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

import org.apache.log4j.Logger;

/**
 * Stream handling utilities for testing.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class StreamUtils {
	private static Logger log = Logger.getLogger( StreamUtils.class );

	/**
	 * Read the supplied InputStream and return as an array of bytes.
	 * @param stream The stream to read.
	 * @return The stream contents in an array of bytes.
	 */
	public static byte[] readStream(InputStream stream) {
		ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
		byte[] buffer = new byte[256];
		int readCount = 0;
		
		try {
			while((readCount = stream.read(buffer)) != -1) {
				outBuffer.write(buffer, 0, readCount);
			}
		} catch (IOException e) {
			log.error(e);
			TestCase.fail("Error reading input stream - See above stack trace.");
		}		
		
		return outBuffer.toByteArray();
	}
}
