/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.util;

import org.jboss.soa.esb.ConfigurationException;

import java.io.File;
import java.io.UnsupportedEncodingException;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class StreamUtilsUnitTest extends TestCase {

    private String filename = "rosetta/tests/src/org/jboss/internal/soa/esb/util/testprops.properties";
    private File file = new File(filename);

    public void test_getResource() throws ConfigurationException {

        if(!file.exists()) {
            fail("Test fixture error - file " + file.getAbsolutePath() + " not found.");
        }

        // Test the filesystem based lookup...
        assertNotNull(StreamUtils.getResource(filename));

        // Test the classpath based lookup...
        assertNotNull(StreamUtils.getResource("testprops.properties"));

        // Test the URI based lookup...
        assertNotNull(StreamUtils.getResource(file.toURI().toString()));
    }

    public void test_getResourceAsString() throws ConfigurationException, UnsupportedEncodingException {

        // No need to test everything - they're tested with the above
        assertEquals("myprop=xyz", StreamUtils.getResourceAsString(filename, "UTF-8"));

        try {
            StreamUtils.getResourceAsString("/x/d/f/s.m", "UTF-8");
            fail("Expected ConfigurationException.");
        } catch(ConfigurationException e) {
            assertEquals("Failed to locate resource '/x/d/f/s.m'.", e.getMessage());
        }
    }
}
