/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.jca;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

/**
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public class JcaInflowGateway extends BaseJcaInflow<InflowGateway>
{
   private static final long serialVersionUID = 1L;
   private String serviceName;
   private String serviceCategory;

   public JcaInflowGateway(ConfigTree config) throws ConfigurationException
   {
      super(config, InflowGateway.class);

      serviceCategory = ListenerUtil.getValue(config,
            ListenerTagNames.TARGET_SERVICE_CATEGORY_TAG, null);
      serviceName = ListenerUtil.getValue(config,
            ListenerTagNames.TARGET_SERVICE_NAME_TAG, null);

      if (serviceCategory == null)
    	  throw new ConfigurationException("No service category defined!");
      
      if (serviceName == null)
    	  throw new ConfigurationException("No service name defined!");
   }
   
   @Override
   protected String getDescription()
   {
      return "category: " + serviceCategory + " service: " + serviceName ;
   }
   
   @Override
   protected void doInitialise() throws ManagedLifecycleException
   {
      super.doInitialise();
      try
      {
         final ServiceInvoker invoker = new ServiceInvoker(serviceCategory, serviceName);
         bean.setServiceInvoker(invoker);
      }
      catch (final MessageDeliverException mde)
      {
         throw new ManagedLifecycleException("Failed to activate JCA Inflow Gateway. Service '" + serviceCategory + ":" + serviceName + "'", mde) ;
      }
   }
}
