/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.jca;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

/**
 * comment
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class EndpointFactory implements MessageEndpointFactory
{
   private EndpointContainer container;
   private Class messagingType;
   private ClassLoader loader;

   private Constructor proxyConstructor;


   public EndpointContainer getContainer()
   {
      return container;
   }

   public void setContainer(EndpointContainer container)
   {
      this.container = container;
   }


   public void setMessagingType(Class messagingType)
   {
      this.messagingType = messagingType;
   }

   public void setLoader(ClassLoader loader)
   {
      this.loader = loader;
   }

   public void start()
   {
      Class[] interfaces = {messagingType, MessageEndpoint.class};
      Class proxyClass = Proxy.getProxyClass(loader, interfaces);
      final Class[] constructorParams = {InvocationHandler.class};
      try
      {
         proxyConstructor = proxyClass.getConstructor(constructorParams);
      }
      catch (NoSuchMethodException e)
      {
         throw new RuntimeException(e);
      }
   }

   public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException
   {
      EndpointProxy proxy = new EndpointProxy();
      proxy.setXaResource(xaResource);
      proxy.setMessageEndpointFactory(this);
      proxy.setContainer(container);
      proxy.setLoader(loader);
      Object[] args = {proxy};
      try
      {
         return (MessageEndpoint) proxyConstructor.newInstance(args);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return null;
      }
   }

   public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException
   {
      return container.isDeliveryTransacted(method);
   }
}
