/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.soa.esb.listeners.ha;

import java.util.List;

import org.jboss.soa.esb.addressing.EPR;

/**
 * LoadBalancingPolicy implementation that always favors the next available
 * epr load balancing always occurs.
 * 
 * Code based on jbossas ha framework.
 *  
 * @author <a href="mailto:kurt@osconsulting.org">Kurt Stam</a>.
 *
 */
public class RoundRobin implements LoadBalancePolicy
{
   private static final long serialVersionUID = 1L;

   public EPR chooseEPR (ServiceClusterInfo serviceCluster)
   {
      int cursor = serviceCluster.getCursor ();
      List<EPR> eprs = serviceCluster.getEPRs ();

      if (eprs.size () == 0) {
         return null;
      }
      if (cursor == ServiceClusterInfo.UNINITIALIZED_CURSOR) {         
         // Obtain a random index into eprs
         cursor = RandomRobin.localRandomizer.nextInt(eprs.size());
      } else {
         // Choose the next epr
         cursor = ( (cursor + 1) % eprs.size() );
      }
      serviceCluster.setCursor (cursor);

      return eprs.get(cursor);
   }

}
